﻿#include "TA-DesignerPCH.h"
#include "utf8.h"


utf8::utf8()
{
 text=0;
 lange=0;
 position=0;
}

void utf8::set_prop(char* sp, unsigned int leng, unsigned int pos)
{

 	text=sp;
	lange=leng;
	position=pos;




}


char utf8::set_text(char * str)
{
	int i=0;

	while(1)
	{	if(set_char(str[i])=='\0')
			return 0;

	 	if(set_char(str[i]))
	 		return (char)-1;
	 	i++;


	}
	
 
}
char utf8::set_char(unsigned int a)
{
	if(position>=lange)
		return (char) -1;

	if(a<0x80)
	{	text[position]=(char)a;
	 	position++;
		return 0;
	}
	if(a<0x800)
	{
	 	if((position+1)>=lange)
			return (char) -1;
		text[position]=(char)(0xC0|((a&0x7C0)>>6));
		position++;
		text[position]=0x80|(a&0x3F);
		position++;
		return 0;
	}
	if(a<0x10000)
	{
	 	if((position+2)>=lange)
			return (char) -1;
		text[position]=0xE0|((a&0xF000)>>12);
		position++;
		text[position]=(char)(0x80|((a&0xFC0)>>6));
		position++;
		text[position]=0x80|(a&0x3F);
		position++;
		return 0;
	}
	if(a<0x100000)
	{
	 	if((position+3)>=lange)
			return (char) -1;
		text[position]=(char)(0xF0|((a&0x1C0000)>>18));
		position++;
		text[position]=(char)(0x80|((a&0x3F000)>>12));
		position++;
		text[position]=(char)(0x80|((a&0xFC0)>>6));
		position++;
		text[position]=0x80|(a&0x3F);
		position++;
		return 0;
	}
	return (char) -2;


}

unsigned int utf8::get_firstchar(void)
{
	position=0;
	return get_nextchar();
	

}
unsigned int utf8::get_nextchar(void)
{	unsigned int temp;

	if(!(text[position]&0x80))
	{	temp=	text[position];
		position++;
		return temp;
	}
	else if ((text[position]&0xE0)==0xC0)
	{
		 temp=((text[position]&0x1F)<<6);
		 position++;
		 temp|=	text[position]&0x3F;
		 position++;
		 return temp;

	}
	else if ((text[position]&0xF0)==0xE0)
	{
		 temp=((text[position]&0x0F)<<12);
		 position++;
		 temp|=((text[position]&0x3F)<<6);
		 position++;
		 temp|=(text[position]&0x3F);
		 position++;
		 return temp;


	}
	else if ((text[position]&0xF8)==0xF0)
	{
		 temp=((text[position]&0x07)<<18);
		 position++;
		 temp|=((text[position]&0x3F)<<12);
		 position++;
		 temp|=((text[position]&0x3F)<<6);
		 position++;
		 temp|=(text[position]&0x3F);
		 position++;
		 return temp;

	}
	return 0;
}
