﻿#include "TA-DesignerPCH.h"
#include "font.h"

BuchstabenFileZuordnung font::bfz;

font::font() : DejavuSans()
{
	for (int i = 0; i<BUCHSTABEN_PRO_FONT; i++)
	{
		for (int j = 0; j<anzahl_DEJAVUSANSFONTS; j++)
		{
			Buchstabe[i][j] = -1;
		}
	}

	last_pos = 0;

	//debug
	debugfile = 0;
}

void font::defrag_changePointer( int start, int len )
{
	for (int i = 0; i<len; i++)
	{
		for (int j = 0; j<BUCHSTABEN_PRO_FONT; j++)
		{
			if (Buchstabe[j][i] == start)
				Buchstabe[j][i] = -1;
			else if (Buchstabe[j][i]>start)
				Buchstabe[j][i] -= len;
		}
	}
}

int font::free_fontmem( int size )
{
	int free = 0;
	while (free<size)
	{
		if (last_pos<4)	//Kein Zeitstempel vorhanden
			return 0;

		int i = 0;

		unsigned short *timestamp;
		unsigned short time;

		time = 0xffff;

		while (i<last_pos);
		{
			timestamp = (unsigned short*)&fontmem[i];
			if (time>*timestamp)
				time = *timestamp;
			i += (((fontmem[i + 2] * 255 + fontmem[i + 3]) / 32 + 1)*(fontmem[i + 4] * 255 + fontmem[i + 5])) + 2;
		}
		unsigned short temptime = 0xffff;
		while (i<last_pos);
		{
			timestamp = (unsigned short*)&fontmem[i];
			if (temptime == *timestamp)	//Löschen und nachrücken
			{
				unsigned short next = (((fontmem[i + 2] * 255 + fontmem[i + 3]) / 32 + 1)*(fontmem[i + 4] * 255 + fontmem[i + 5])) + 2;
				defrag_changePointer( i, next );

				while ((i + next)<last_pos)
				{
					fontmem[i] = fontmem[i + next];
				}
				free += next;
				break;
			}
			i += (((fontmem[i + 2] * 255 + fontmem[i + 3]) / 32 + 1)*(fontmem[i + 4] * 255 + fontmem[i + 5])) + 2;
		}
	}
	return free;
}



char font::load_Buchstabe( unsigned int Unicode, unsigned char font )
{

	if ((bfz.data[2] == 0) && (bfz.data[3] == 0)) //bfz nicht geladen, kein Ende des ersten Bereiches
	{
		wxFile ifile;
		ifile.Open( g_root_dir + wxFILE_SEP_PATH + "font" + wxFILE_SEP_PATH + "dic.caf", wxFile::read );
		if (ifile.IsOpened())
		{
			ifile.Read( bfz.data, sizeof( bfz.data ) );
			ifile.Close();
		}
		else
			return (char)-1;
	}

	int i;
	for (i = 0; i<NUMBER_FILES; i++)
	{
		if ((Unicode >= bfz.page[i].start) && (Unicode <= bfz.page[i].ende))
			break;
	}
	if (i == NUMBER_FILES)
		return (char)-2;

	wxString fontPath;
	fontPath.Printf( "%s%cfont%c%s%c%s", g_root_dir, wxFILE_SEP_PATH, wxFILE_SEP_PATH, dirName[font], wxFILE_SEP_PATH, (bfz.page[i].file) );

	wxFile ifile;
	ifile.Open( fontPath, wxFile::read );
	if (ifile.IsOpened())
	{
		for (int j = bfz.page[i].start; j <= bfz.page[i].ende; j++)
		{
			unsigned short x = 0, y = 0;

			unsigned short ax = 0;
			ifile.Read( &x, sizeof( unsigned short ) * 1 );
			ifile.Read( &y, sizeof( unsigned short ) * 1 );
			//ax=x/32;
			ax = (x + 31) / 32;
			//ax++;

			if ((ax*y)> (font_max_mem - last_pos))
			{
				wxASSERT(false);
			}

			*((unsigned int*)(&fontmem[last_pos])) = (y << 16 | x);

			if (ifile.Read( &fontmem[last_pos + 4], sizeof( unsigned int )*ax*y ) != sizeof( unsigned int )*(ax*y))	//Lesefehler
				return (char)-4;
			else
			{
				Buchstabe[j][font] = last_pos;
				last_pos += (ax*y + 1) * 4;
				fontmem[last_pos] = 0xff;
				last_pos++;
				fontmem[last_pos] = 0xff;
				last_pos++;


				last_pos++;
				last_pos++;

				if (last_pos>font_max_mem)
				{
					wxASSERT( false );
				}
			}
		}
		ifile.Close();
	}
	else
		return (char)-3;


	return 0;
}


void font::get_Buchstabe( unsigned int Unicode, unsigned char fontart, unsigned short *x, unsigned short *y, unsigned int ** point )
{
	if ((Buchstabe[Unicode][fontart]<0) && (Buchstabe[Unicode][fontart]>-5))	//Buchstabe laden
	{
		if (load_Buchstabe( Unicode, fontart ))
			Buchstabe[Unicode][fontart]--;
	}
	if (Buchstabe[Unicode][fontart] >= 0)
	{
		*x = *((unsigned short*)(&fontmem[Buchstabe[Unicode][fontart]]));
		*y = *((unsigned short*)(&fontmem[Buchstabe[Unicode][fontart] + 2]));
		*point = (unsigned int*)(&fontmem[Buchstabe[Unicode][fontart] + 4]);
	}
	else
	{
		*x = 0;
		*y = 0;
	}
}

DejavuSans::DejavuSans()
{
	wxString bold = wxT(" ") + _("Fett");

	dirName[CAN_TOUCH_FONT_0] = wxT( "font0" );
	fontName[CAN_TOUCH_FONT_0] = _( "Größe" ) + wxT( " 0" );
	orderInDialog_x2tech[CAN_TOUCH_FONT_0] = -1;
	orderInDialog_CANTouch[CAN_TOUCH_FONT_0] = 2;
	orderInDialog_TextFo[CAN_TOUCH_FONT_0] = -1;

	dirName[CAN_TOUCH_FONT_m1] = wxT( "font1" );
	fontName[CAN_TOUCH_FONT_m1] = _( "Größe" ) + wxT( " -1" );
	orderInDialog_x2tech[CAN_TOUCH_FONT_m1] = -1;
	orderInDialog_CANTouch[CAN_TOUCH_FONT_m1] = 1;
	orderInDialog_TextFo[CAN_TOUCH_FONT_m1] = -1;

	dirName[CAN_TOUCH_FONT_p1] = wxT( "font2" );
	fontName[CAN_TOUCH_FONT_p1] = _( "Größe" ) + wxT( " +1" );
	orderInDialog_x2tech[CAN_TOUCH_FONT_p1] = -1;
	orderInDialog_CANTouch[CAN_TOUCH_FONT_p1] = 3;
	orderInDialog_TextFo[CAN_TOUCH_FONT_p1] = -1;

	dirName[CAN_TOUCH_FONT_m2] = wxT( "font3" );
	fontName[CAN_TOUCH_FONT_m2] = _( "Größe" ) + wxT( " -2" );
	orderInDialog_x2tech[CAN_TOUCH_FONT_m2] = -1;
	orderInDialog_CANTouch[CAN_TOUCH_FONT_m2] = 0;
	orderInDialog_TextFo[CAN_TOUCH_FONT_m2] = -1;

	dirName[CAN_TOUCH_FONT_p2] = wxT( "font4" );
	fontName[CAN_TOUCH_FONT_p2] = _( "Größe" ) + wxT( " +2" );
	orderInDialog_x2tech[CAN_TOUCH_FONT_p2] = -1;
	orderInDialog_CANTouch[CAN_TOUCH_FONT_p2] = 4;
	orderInDialog_TextFo[CAN_TOUCH_FONT_p2] = -1;

	dirName[x2TECH_FONT_15] = wxT( "15" );
	fontName[x2TECH_FONT_15] = wxT( "15" );
	orderInDialog_x2tech[x2TECH_FONT_15] = 0;
	orderInDialog_CANTouch[x2TECH_FONT_15] = -1;
	orderInDialog_TextFo[x2TECH_FONT_15] = -1;

	dirName[x2TECH_FONT_15B] = wxT( "15B" );
	fontName[x2TECH_FONT_15B] = wxT( "15" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_15B] = 1;
	orderInDialog_CANTouch[x2TECH_FONT_15B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_15B] = -1;

	dirName[x2TECH_FONT_15M] = wxT( "15M" );
	fontName[x2TECH_FONT_15M] = wxT( "15M" );
	orderInDialog_x2tech[x2TECH_FONT_15M] = 2;
	orderInDialog_CANTouch[x2TECH_FONT_15M] = -1;
	orderInDialog_TextFo[x2TECH_FONT_15M] = -1;

	dirName[x2TECH_FONT_18] = wxT( "18" );
	fontName[x2TECH_FONT_18] = wxT( "18" );
	orderInDialog_x2tech[x2TECH_FONT_18] = 3;
	orderInDialog_CANTouch[x2TECH_FONT_18] = -1;
	orderInDialog_TextFo[x2TECH_FONT_18] = -1;

	dirName[x2TECH_FONT_18B] = wxT( "18B" );
	fontName[x2TECH_FONT_18B] = wxT( "18" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_18B] = 4;
	orderInDialog_CANTouch[x2TECH_FONT_18B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_18B] = -1;

	dirName[x2TECH_FONT_20] = wxT( "20" );
	fontName[x2TECH_FONT_20] = wxT( "20" );
	orderInDialog_x2tech[x2TECH_FONT_20] = 5;
	orderInDialog_CANTouch[x2TECH_FONT_20] = -1;
	orderInDialog_TextFo[x2TECH_FONT_20] = -1;

	dirName[x2TECH_FONT_20B] = wxT( "20B" );
	fontName[x2TECH_FONT_20B] = wxT( "20" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_20B] = 6;
	orderInDialog_CANTouch[x2TECH_FONT_20B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_20B] = -1;

	dirName[x2TECH_FONT_24] = wxT( "24" );
	fontName[x2TECH_FONT_24] = wxT( "24" );
	orderInDialog_x2tech[x2TECH_FONT_24] = 7;
	orderInDialog_CANTouch[x2TECH_FONT_24] = -1;
	orderInDialog_TextFo[x2TECH_FONT_24] = -1;

	dirName[x2TECH_FONT_24B] = wxT( "24B" );
	fontName[x2TECH_FONT_24B] = wxT( "24" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_24B] = 8;
	orderInDialog_CANTouch[x2TECH_FONT_24B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_24B] = -1;
	
	dirName[x2TECH_FONT_31] = wxT( "31" );
	fontName[x2TECH_FONT_31] = wxT( "31" );
	orderInDialog_x2tech[x2TECH_FONT_31] = 9;
	orderInDialog_CANTouch[x2TECH_FONT_31] = -1;
	orderInDialog_TextFo[x2TECH_FONT_31] = -1;

	dirName[x2TECH_FONT_31B] = wxT( "31B" );
	fontName[x2TECH_FONT_31B] = wxT( "31" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_31B] = 10;
	orderInDialog_CANTouch[x2TECH_FONT_31B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_31B] = -1;

	dirName[x2TECH_FONT_40] = wxT( "40" );
	fontName[x2TECH_FONT_40] = wxT( "40" );
	orderInDialog_x2tech[x2TECH_FONT_40] = 11;
	orderInDialog_CANTouch[x2TECH_FONT_40] = -1;
	orderInDialog_TextFo[x2TECH_FONT_40] = -1;

	dirName[x2TECH_FONT_40B] = wxT( "40B" );
	fontName[x2TECH_FONT_40B] = wxT( "40" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_40B] = 12;
	orderInDialog_CANTouch[x2TECH_FONT_40B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_40B] = -1;

	dirName[x2TECH_FONT_50] = wxT( "50" );
	fontName[x2TECH_FONT_50] = wxT( "50" );
	orderInDialog_x2tech[x2TECH_FONT_50] = 13;
	orderInDialog_CANTouch[x2TECH_FONT_50] = -1;
	orderInDialog_TextFo[x2TECH_FONT_50] = -1;

	dirName[x2TECH_FONT_50B] = wxT( "50B" );
	fontName[x2TECH_FONT_50B] = wxT( "50" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_50B] = 14;
	orderInDialog_CANTouch[x2TECH_FONT_50B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_50B] = -1;

	dirName[x2TECH_FONT_70] = wxT( "70" );
	fontName[x2TECH_FONT_70] = wxT( "70" );
	orderInDialog_x2tech[x2TECH_FONT_70] = 15;
	orderInDialog_CANTouch[x2TECH_FONT_70] = -1;
	orderInDialog_TextFo[x2TECH_FONT_70] = -1;

	dirName[x2TECH_FONT_70B] = wxT( "70B" );
	fontName[x2TECH_FONT_70B] = wxT( "70" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_70B] = 16;
	orderInDialog_CANTouch[x2TECH_FONT_70B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_70B] = -1;

	dirName[x2TECH_FONT_102B] = wxT( "102B" );
	fontName[x2TECH_FONT_102B] = wxT( "102" ) + bold;
	orderInDialog_x2tech[x2TECH_FONT_102B] = 17;
	orderInDialog_CANTouch[x2TECH_FONT_102B] = -1;
	orderInDialog_TextFo[x2TECH_FONT_102B] = -1;

	dirName[TEXTFO_FONT_6x8] = wxT("6x8");
	fontName[TEXTFO_FONT_6x8] = wxT("8");
	orderInDialog_x2tech[TEXTFO_FONT_6x8] = -1;
	orderInDialog_CANTouch[TEXTFO_FONT_6x8] = -1;
	orderInDialog_TextFo[TEXTFO_FONT_6x8] = 0;

	dirName[TEXTFO_FONT_8x8] = wxT("8x8");
	fontName[TEXTFO_FONT_8x8] = wxT("8") + bold;
	orderInDialog_x2tech[TEXTFO_FONT_8x8] = -1;
	orderInDialog_CANTouch[TEXTFO_FONT_8x8] = -1;
	orderInDialog_TextFo[TEXTFO_FONT_8x8] = 1;
}

void DejavuSans::getCANTouchStringArray( wxArrayString* s)
{
	for (unsigned int row = 0; row < anzahl_DEJAVUSANSFONTS; row++)
	{
		for (unsigned int i = 0; i < anzahl_DEJAVUSANSFONTS; i++)
		{
			if (orderInDialog_CANTouch[i] == row)
				s->Add( fontName[i] );
		}
	}
}

void DejavuSans::getTextFoStringArray(wxArrayString* s)
{
	for (unsigned int row = 0; row < anzahl_DEJAVUSANSFONTS; row++)
	{
		for (unsigned int i = 0; i < anzahl_DEJAVUSANSFONTS; i++)
		{
			if (orderInDialog_TextFo[i] == row)
				s->Add(fontName[i]);
		}
	}
}

void DejavuSans::getx2TechStringArray( wxArrayString* s )
{
	for (unsigned int row = 0; row < anzahl_DEJAVUSANSFONTS; row++)
	{
		for (unsigned int i = 0; i < anzahl_DEJAVUSANSFONTS; i++)
		{
			if (orderInDialog_x2tech[i] == row)
				s->Add( fontName[i] );
		}
	}
}

int DejavuSans::getFontValueFromSelection_CANTouch( int selectedFont )
{
	for (unsigned int i = 0; i < anzahl_DEJAVUSANSFONTS; i++)
	{
		if (orderInDialog_CANTouch[i] == selectedFont)
			return i;
	}
	return CAN_TOUCH_FONT_0;
}

int DejavuSans::getFontValueFromSelection_TextFo(int selectedFont)
{
	for (unsigned int i = 0; i < anzahl_DEJAVUSANSFONTS; i++)
	{
		if (orderInDialog_TextFo[i] == selectedFont)
			return i;
	}
	return CAN_TOUCH_FONT_0;
}

int DejavuSans::getFontValueFromSelection_x2Tech( int selectedFont )
{
	for (unsigned int i = 0; i < anzahl_DEJAVUSANSFONTS; i++)
	{
		if (orderInDialog_x2tech[i] == selectedFont)
			return i;
	}
	return x2TECH_FONT_15B;
}

void DejavuSans::getFontPixelSize( int font, int* pixelSize, bool* isbold )
{
	int size = 0;
	bool bold = false;
	switch (font)
	{
	case CAN_TOUCH_FONT_m2:
		size = 16;
		break;

	case CAN_TOUCH_FONT_m1:
		size = 19;
		break;

	case CAN_TOUCH_FONT_0:
		size = 28;
		break;

	case CAN_TOUCH_FONT_p1:
		size = 38;
		break;

	case CAN_TOUCH_FONT_p2:
		size = 55;
		break;

	case x2TECH_FONT_15:
		size = 15;
		break;

	case x2TECH_FONT_15B:
		size = 15;
		bold = true;
		break;

	case x2TECH_FONT_15M:
		size = 15;
		break;

	case x2TECH_FONT_18:
		size = 18;
		break;

	case x2TECH_FONT_20B:
		size = 20;
		bold = true;
		break;

	case x2TECH_FONT_24:
		size = 24;
		break;

	case x2TECH_FONT_24B:
		size = 24;
		bold = true;
		break;

	case x2TECH_FONT_31:
		size = 31;
		break;

	case x2TECH_FONT_31B:
		size = 31;
		bold = true;
		break;

	case x2TECH_FONT_40:
		size = 40;
		break;

	case x2TECH_FONT_40B:
		size = 40;
		bold = true;
		break;

	case x2TECH_FONT_50:
		size = 50;
		break;

	case x2TECH_FONT_50B:
		size = 50;
		bold = true;
		break;

	case x2TECH_FONT_70:
		size = 70;
		break;

	case x2TECH_FONT_70B:
		size = 70;
		bold = true;
		break;

	case x2TECH_FONT_102B:
		size = 102;
		bold = true;
		break;

	case x2TECH_FONT_18B:
		size = 18;
		bold = true;
		break;

	case x2TECH_FONT_20:
		size = 20;
		break;

	case TEXTFO_FONT_6x8:
		size = 8;
		break;

	case TEXTFO_FONT_8x8:
		size = 8;
		break;

	default:
		size = 22;
		break;

	}

	if(pixelSize != NULL)
		(*pixelSize) = size;
	if(isbold != NULL)
		(*isbold) = bold;
}