﻿#ifndef __font_h__
#define __font_h__

#define font_max_mem 7233536	//größe der Fonts im Verzeichnis
#define BUCHSTABEN_PRO_FONT 65535
#define NUMBER_FILES 353

#ifdef __PC__
#include <wx/textfile.h> 
#define _CRT_SECURE_NO_WARNINGS
#else
#include <rtl.h>

#endif

#include <stdio.h>
#include <string.h>
#include <wx/stdpaths.h>


enum DejavuSansFonts
{
	CAN_TOUCH_FONT_0,
	CAN_TOUCH_FONT_m1,
	CAN_TOUCH_FONT_p1,
	CAN_TOUCH_FONT_m2,
	CAN_TOUCH_FONT_p2,
	x2TECH_FONT_15,
	x2TECH_FONT_15B,
	x2TECH_FONT_15M,
	x2TECH_FONT_18,
	x2TECH_FONT_20B,
	x2TECH_FONT_24,
	x2TECH_FONT_24B,
	x2TECH_FONT_31,
	x2TECH_FONT_31B,
	x2TECH_FONT_40,
	x2TECH_FONT_40B,
	x2TECH_FONT_50,
	x2TECH_FONT_50B,
	x2TECH_FONT_70,
	x2TECH_FONT_70B,
	x2TECH_FONT_102B,
	x2TECH_FONT_18B,
	x2TECH_FONT_20,
	TEXTFO_FONT_6x8,
	TEXTFO_FONT_8x8,
	anzahl_DEJAVUSANSFONTS
};

struct BZuordnung
{
	unsigned short start : 16;
	unsigned short ende : 16;
	char file[12];
};

union BuchstabenFileZuordnung
{
	BZuordnung page[NUMBER_FILES];

	unsigned char data[16 * NUMBER_FILES];

	BuchstabenFileZuordnung(){ for (int i = 0; i<12 * NUMBER_FILES; i++){ data[i] = 0; } }
};

class DejavuSans
{
public:
	DejavuSans();

	void getCANTouchStringArray( wxArrayString* s);
	void getx2TechStringArray( wxArrayString* s);
	void getTextFoStringArray(wxArrayString* s);
	int getFontValueFromSelection_CANTouch( int selectedFont );
	int getFontValueFromSelection_x2Tech( int selectedFont );
	int getFontValueFromSelection_TextFo(int selectedFont);
	int getOrderInx2TechDialogValue( int i ){ return orderInDialog_x2tech[i]; }
	int getOrderInCANTouchDialogValue( int i ){ return orderInDialog_CANTouch[i]; }
	int getOrderInTextFoDialogValue(int i) { return orderInDialog_TextFo[i]; }

	static void getFontPixelSize( int i, int* pixelSize, bool* bold );

protected:
	wxString dirName[anzahl_DEJAVUSANSFONTS];
	wxString fontName[anzahl_DEJAVUSANSFONTS];
	int orderInDialog_CANTouch[anzahl_DEJAVUSANSFONTS];
	int orderInDialog_x2tech[anzahl_DEJAVUSANSFONTS];
	int orderInDialog_TextFo[anzahl_DEJAVUSANSFONTS];
};

class font : public DejavuSans
{
private:

	int Buchstabe[BUCHSTABEN_PRO_FONT][anzahl_DEJAVUSANSFONTS];
	unsigned char fontmem[font_max_mem];
	int last_pos;

	static BuchstabenFileZuordnung bfz;
	void defrag_changePointer( int start, int len );
	char load_Buchstabe( unsigned int Unicode, unsigned char font );
	int free_fontmem( int size );

	//debug
	int debugfile;

public:

	font();
	void get_Buchstabe( unsigned int Unicode, unsigned char fontart, unsigned short *x, unsigned short *y, unsigned int ** point );

};


#endif		

